/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
Analysis of correlation between capital shares and top income inequality using data from bengtsson-waldenstrom
5.10.2020
Pascual Restrepo
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

global project  "C:\Users\Pascual Restrepo\Dropbox\Research\wealth_inequality\AutomationInequality\replication_mrr_may_2020\s3_confronting_model\s3c_bw_data"

* import data *
import excel "${project}/raw_data/Capital Share Database.xlsx", sheet("Capital Shares Database") cellrange(A9:J2078) firstrow clear

encode Country, gen(ccode)

* generate logs of top income shares *
foreach var in Top10incomeshare Top1incomeshare Top01incomeshare Top10incomeshareinclcapit Top1incomeshareinclcapita Top01incomeshareinclcapi{
gen ln_`var'=100*ln(`var')
}

* estimate log-linear specifications reported in the paper *
reg ln_Top10incomeshare  Netcapitalshare i.ccode, cluster(Year)
unique Country if e(sample)==1
sum Year if e(sample)==1

reg ln_Top1incomeshare   Netcapitalshare i.ccode, cluster(Year)
unique Country if e(sample)==1
sum Year if e(sample)==1

reg ln_Top01incomeshare  Netcapitalshare i.ccode, cluster(Year)
unique Country if e(sample)==1 
sum Year if e(sample)==1


* robustness checks: keep data for every five years *
keep if 5*floor(Year/5)==Year
* estimate log-linear specification using data for every five years *
reg ln_Top10incomeshare  Netcapitalshare i.ccode, cluster(Year)
unique Country if e(sample)==1
sum Year if e(sample)==1

reg ln_Top1incomeshare   Netcapitalshare i.ccode, cluster(Year)
unique Country if e(sample)==1
sum Year if e(sample)==1

reg ln_Top01incomeshare  Netcapitalshare i.ccode, cluster(Year)
unique Country if e(sample)==1 
sum Year if e(sample)==1

* controlling for trends, country-specific trends and year-fixed effects *

* top 0.1% share *
reg ln_Top01incomeshare   Netcapitalshare i.ccode, cluster(Year)
reg ln_Top01incomeshare   Netcapitalshare i.ccode c.Year##c.Year, cluster(Year)
reg ln_Top01incomeshare   Netcapitalshare i.ccode i.ccode#c.Year, cluster(Year)
reg ln_Top01incomeshare   Netcapitalshare i.ccode i.Year

* top 1% share *
reg ln_Top1incomeshare   Netcapitalshare i.ccode, cluster(Year)
reg ln_Top1incomeshare   Netcapitalshare i.ccode c.Year##c.Year, cluster(Year)
reg ln_Top1incomeshare   Netcapitalshare i.ccode i.ccode#c.Year, cluster(Year)
reg ln_Top1incomeshare   Netcapitalshare i.ccode i.Year

* top 10% share *
reg ln_Top10incomeshare   Netcapitalshare i.ccode, cluster(Year)
reg ln_Top10incomeshare   Netcapitalshare i.ccode c.Year##c.Year, cluster(Year)
reg ln_Top10incomeshare   Netcapitalshare i.ccode i.ccode#c.Year, cluster(Year)
reg ln_Top10incomeshare   Netcapitalshare i.ccode i.Year
